# Словари
Словарь — структура данных, которая позволяет сопоставлять ключи со значениями так же, как настоящий словарь сопоставляет слова с их определениями, что облегчает поиск.

Словарь можно создать так:
`right_of = {North:East, East:South, South:West, West:North}`

Выражение перед двоеточием — это ключ, а выражение после двоеточия — значение, которому сопоставлен ключ.
Вышеуказанный словарь сопоставляет каждое направление с направлением справа от него.

Вот еще один, который сопоставляет позицию дрона с объектом-сущностью под ним.
`x, y = get_pos_x(), get_pos_y()
entity_dict = {(x,y):get_entity_type()}`

Значение, сопоставленное с ключом, получают аналогично с элементом списка:
`value = dict[key]`

Пример:
`orientation = right_of[South]`
Это устанавливает для `orientation` значение `West`.

Ты можешь добавить новую пару ключ-значение в словарь так:
`dict[key] = value`

Пример:
`entity_dict[(get_pos_x(), get_pos_y())] = get_entity_type()`
Это обновляет сохраненный объект-сущность для текущей позиции.

Ключи уникальны, поэтому добавление ключа, который уже существует в словаре, перезапишет предыдущее значение.

Для удаления пары ключ-значение из `dict` используй `dict.pop(key)`.

`key in dict` равно `True`, если `key` является ключом в `dict`, в противном случае — `False`.
Таким образом, можно использовать `if key in dict:`, чтобы проверить, содержит ли `dict` ключ.

Использование словаря в цикле `for` позволяет перебирать все ключи:
`for key in dict:
	value = dict[key]`

Нельзя с точностью сказать, в каком порядке будет выполнен перебор.

См. также [Множества](docs/scripting/sets.md)